'''
Tool for generating a list of albums from iTunes Library
- Author: Mathias Beke - http://denbeke.be
- Created: 7-3-2013
'''

from AlbumListGenerator import *
import sys

class TableGenerator:
    '''Class for generating a HTML file with a list of albums. Input comes from iTune Library XML file'''
    
    
    def __init__(self, input_file, output_file):
        '''Constructor'''
        
        #html header
        self.htmlHeader = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"utf-8\"><title>iTunes Albums</title><!--[if lt IE 9]><script src=\"http://html5shim.googlecode.com/svn/trunk/html5.js\"></script><![endif]--></head><body><table><tbody><tr><th>Album</th><th>Artiest</th><th>Year</th></tr>"
        
        #empty content, content is created with generateHTMLContent()
        self.htmlContent = ""
        
        #html footer
        self.htmlFooter = "</tbody></table></body></html>"
        
        self.albumList = AlbumListGenerator(input_file)
        self.outputFile = output_file
        self.albumList.generateList()

    
    def generateHTMLContent(self):
        '''Generates the string containing the albums formatted in HTML'''
        
        #Loop through all albuls
        for album in self.albumList.getList():
            line = "" #reset line
            line += "<tr><td>"+album.getAlbum()+"</td><td>"+album.getArtist()+"</td><td>"+album.getYear()+"</td></tr>" #format line           
            self.htmlContent += line #Add line to content
            
      
    def writeFile(self):
        '''Writes the html code to a file'''
        self.generateHTMLContent()
        file = open(outputFile, 'w')
        file.write(self.htmlHeader+self.htmlContent+self.htmlFooter)
        file.close()
        
        
        
if __name__ == '__main__':
        
    #Fetch command line arguments
    info = sys.argv
    
    #Check for input file
    try:
        
        executable = info[0]
        inputFile = info[1]
    
        #Check for output file
        try:
            
            outputFile = info[2]
    
            print("Trying to read '"+str(inputFile)+"'")
            
            #Make HTML table
            try:
                table = TableGenerator(inputFile, outputFile)
                table.albumList.sortList()
                
                
                #Write table to the given html file
                try:
                    table.writeFile()
                    print("'"+str(inputFile)+"' successfully parsed and written to file '"+str(outputFile)+"'")
                except:
                    print("Could not write to output file '"+str(outputFile)+"'")
                
                
            except:
                print("ERROR: cannot parse '"+str(inputFile)+"'")
            
            
                
                
        
        except:
            
            print("Please give the name for the output html file")
            print("Usage: "+str(executable)+" inputFile outputFile")
            
        
            
    except:
        print("Please give an XML library as input file")
        print("Usage: "+str(executable)+" inputFile outputFile")
